on encode_XML(this_text)
        --  set search_strings to {"&amp;", "&quot;", "&#39;", "<", ">"}
        --  set replacement_strings to {"&", "\"", "'", "<", ">"}
        set search_strings to {"&", "\"", "'", "<", ">"}
        set replacement_strings to {"&amp;", "&quot;", "&#39;", "&lt;", "&gt;"}
        repeat with i from 1 to (count of search_strings)
                set search_string to item i of search_strings
                set replacement_string to item i of replacement_strings
                if this_text contains search_string then
                        set AppleScript's text item delimiters to search_string
                        set the item_list to every text item of this_text
                        set AppleScript's text item delimiters to replacement_string
                        set this_text to the item_list as string
                        set AppleScript's text item delimiters to ""
                end if
        end repeat
        return this_text
end encode_XML

tell application "iTunes.app"
	
	set ThePrefix to "%@"
	-- set ThePrefix to "DRM Dumpster"
	set TheResultsFile to (path to home folder from user domain as text) & "%@"
	-- set TheResultsFile to (path to home folder from user domain as text) & "test.plist"
	
	set LF to ASCII character 10
	set quoteMark to "\""
	set trackCount to 0
	
	-- Delete the iTunes Converter CD playlist(s) if it exists
	set l_found to 1
	repeat while l_found is equal to 1
		set l_found to 0
		repeat with i from 1 to the count of playlists
			set TheSource to playlist i
			if name of TheSource ends with ThePrefix & " CD" then
				delete TheSource
				set l_found to 1
				exit repeat
			end if
		end repeat
	end repeat
	
	set TheDate to current date
	
	set TheCDPlaylist to (time string of TheDate) & " " & ThePrefix & " CD"
	
	set PlayListTime to (60 * 60)
	set PlayListTotalTime to 0
	set TrackTime to 0
	set NumberOfTrack to 1
	set ListOfTracksToDelete to {}
	try
		make new user playlist with properties {name:TheCDPlaylist}
		repeat while PlayListTotalTime < PlayListTime
			set TrackTime to duration of track NumberOfTrack of playlist ThePrefix
			if TrackTime < (45 * 60) then
				set PlayListTotalTime to PlayListTotalTime + TrackTime
				if PlayListTotalTime < PlayListTime then
					set enabled of (get duplicate (track NumberOfTrack of playlist ThePrefix) to playlist TheCDPlaylist) to true
					set ListOfTracksToDelete to ListOfTracksToDelete & NumberOfTrack
					set trackCount to (trackCount + 1)
				end if
			end if
			set NumberOfTrack to (NumberOfTrack + 1)
		end repeat
		
	on error
		
	end try
	
	
	try
		set results_fd to open for access file TheResultsFile with write permission
	on error
		close access file TheResultsFile
		set results_fd to open for access file TheResultsFile with write permission
	end try
	
	set eof of results_fd to 0
	write "<?xml version=" & quoteMark & "1.0" & quoteMark & " encoding=" & quoteMark & "UTF-8" & quoteMark & "?>" & LF as class utf8 to results_fd
	write "<!DOCTYPE plist PUBLIC " & quoteMark & "-//Apple Computer//DTD PLIST 1.0//EN" & quoteMark & " " & quoteMark & "http://www.apple.com/DTDs/PropertyList-1.0.dtd" & quoteMark & ">" & LF as class utf8 to results_fd
	write "<plist version=" & quoteMark & "1.0" & quoteMark & ">" & LF as class utf8 to results_fd
	write "<dict>" & LF as class utf8 to results_fd
	write tab & "<key>trackstoconvert</key>" & LF as class utf8 to results_fd
	write tab & "<integer>" & (get trackCount as string) & "</integer>" & LF as class utf8 to results_fd
	
	write tab & "<key>trackmetadata</key>" & LF as class utf8 to results_fd
	write tab & tab & "<array>" & LF as class utf8 to results_fd
	
	repeat with a_track in (get every track in playlist TheCDPlaylist)
		
		set track_album to my encode_XML((get album of a_track))
		set track_artist to my encode_XML((get artist of a_track))
		set track_grouping to my encode_XML((get grouping of a_track))
		set track_name to my encode_XML((get name of a_track))
		set track_disc_count to (get disc count of a_track)
		set track_disc_number to (get disc number of a_track)
		set track_count to (get track count of a_track)
		set track_number to (get track number of a_track)
		
		write tab & tab & tab & "<dict>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>album</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<string>" & (get track_album as string) & "</string>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>artist</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<string>" & (get track_artist as string) & "</string>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>grouping</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<string>" & (get track_grouping as string) & "</string>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>name</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<string>" & (get track_name as string) & "</string>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>disccount</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<integer>" & (get track_disc_count as string) & "</integer>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>discnumber</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<integer>" & (get track_disc_number as string) & "</integer>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>trackcount</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<integer>" & (get track_count as string) & "</integer>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<key>tracknumber</key>" & LF as class utf8 to results_fd
		write tab & tab & tab & "<integer>" & (get track_number as string) & "</integer>" & LF as class utf8 to results_fd
		write tab & tab & tab & "</dict>" & LF as class utf8 to results_fd
		
	end repeat
	
	write tab & tab & "</array>" & LF as class utf8 to results_fd
	write "</dict>" & LF as class utf8 to results_fd
	write "</plist>" & LF as class utf8 to results_fd
	close access results_fd
	
	set a_reverse_track_list to reverse of ListOfTracksToDelete
	repeat with a_trackNumber in a_reverse_track_list
		delete track a_trackNumber in playlist ThePrefix
	end repeat
	
	
end tell

